/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.editor.Problem;
import com.quantumdata.fmteditor.editor.ProblemType;
import com.quantumdata.fmteditor.editor.UnitType;
import com.quantumdata.fmteditor.editor.VideoInterface;
import com.quantumdata.fmteditor.editor.VideoMode;
import com.quantumdata.fmteditor.editor.Xvsi;
import com.quantumdata.fmteditor.fmt.Format;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmtChecker {
    private Vector<Problem> m_results;
    private int m_id;
    private Xvsi m_xvsi;
    private UnitType m_unit;
    private Format m_fmt;
    private Vars m_var = new Vars();
    private boolean m_interlace;
    private boolean m_usingTV;
    private boolean m_usingHDMI;
    private boolean m_usingSDI;
    private boolean m_usingDVI;
    private boolean m_usingDP;
    private int m_asct;
    private int m_dsct;
    private int m_dsst;
    private int m_ssst;
    private int m_avst;
    private int m_dvst;
    private int m_scan;
    private int m_htot;
    private int m_hres;
    private int m_hspd;
    private int m_hspw;
    private int m_hvsa;
    private double m_hrat;
    private double m_prat;
    private int m_vtot;
    private int m_vres;
    private int m_vspd;
    private int m_vspw;
    private int m_nbpc;
    private int m_dvsm;
    private int m_nlnk;
    private int m_ncpp;
    private int m_equb;
    private int m_equa;
    private boolean m_hspp;
    private boolean m_vspp;

    public FmtChecker(Format format) {
        this.m_fmt = format;
    }

    protected void error(int n, String string) {
        this.m_results.add(new Problem(ProblemType.ERROR, ++this.m_id, n, string));
    }

    protected void warning(String string) {
        this.m_results.add(new Problem(ProblemType.WARNING, ++this.m_id, string));
    }

    protected void note(String string) {
        this.m_results.add(new Problem(ProblemType.NOTE, ++this.m_id, string));
    }

    protected void msg(boolean bl, int n, String string) {
        if (bl) {
            this.warning(string);
        } else {
            this.error(n, string);
        }
    }

    public void check(Xvsi xvsi, UnitType unitType, Vector<Problem> vector) {
        this.m_xvsi = xvsi;
        this.m_unit = unitType;
        this.m_results = vector;
        this.m_id = 0;
        vector.clear();
        this.initVars();
        this.checkXvsi();
        this.checkSync();
        this.checkdigitalOpts();
        this.checkAudio();
        this.checkAfd();
        if (this.m_fmt.getBool("RFLD") && this.m_scan != 2) {
            this.error(2041, "Repeat field not allowed with progressive");
        }
        this.checkHdtv();
        this.checkPixelRate();
        this.checkVideoMode();
        this.checkHorz();
        this.checkVert();
        this.checkMemory();
        this.checkMisc();
    }

    private void initVars() {
        this.m_usingTV = false;
        this.m_usingHDMI = false;
        this.m_usingSDI = false;
        this.m_usingDVI = false;
        this.m_usingDP = false;
        this.m_avst = this.m_fmt.getInt("AVST");
        this.m_dvst = this.m_fmt.getInt("DVST");
        this.m_scan = this.m_fmt.getInt("SCAN");
        this.m_asct = this.m_fmt.getInt("ASCT");
        this.m_dsst = this.m_fmt.getInt("DSST");
        this.m_dsct = this.m_fmt.getInt("DSCT");
        this.m_ssst = this.m_fmt.getInt("SSST");
        this.m_hres = this.m_fmt.getInt("HRES");
        this.m_htot = this.m_fmt.getInt("HTOT");
        this.m_hspd = this.m_fmt.getInt("HSPD");
        this.m_hspw = this.m_fmt.getInt("HSPW");
        this.m_vres = this.m_fmt.getInt("VRES");
        this.m_vtot = this.m_fmt.getInt("VTOT");
        this.m_vspd = this.m_fmt.getInt("VSPD");
        this.m_vspw = this.m_fmt.getInt("VSPW");
        this.m_nbpc = this.m_fmt.getInt("NBPC");
        this.m_dvsm = this.m_fmt.getInt("DVSM");
        this.m_nlnk = this.m_fmt.getInt("NLNK");
        this.m_hrat = this.m_fmt.getDouble("HRAT");
        this.m_prat = this.m_fmt.getDouble("PRAT");
        this.m_ncpp = this.m_fmt.getInt("NCPP");
        this.m_hvsa = this.m_fmt.getInt("HVSA");
        this.m_equb = this.m_fmt.getInt("EQUB");
        this.m_equa = this.m_fmt.getInt("EQUA");
        this.m_hspp = this.m_fmt.getBool("HSPP");
        this.m_vspp = this.m_fmt.getBool("VSPP");
        if (this.m_xvsi == Xvsi.SDI) {
            this.m_hspw = this.m_htot - this.m_hres;
            this.m_hspd = 0;
            this.m_vspw = this.m_vtot - this.m_vres;
            if (this.m_scan != 1) {
                this.m_vspw /= 2;
            }
            this.m_equa = 0;
            this.m_equb = 0;
            this.m_vspd = 0;
            this.m_hspp = true;
            this.m_vspp = true;
            this.m_ssst = 1;
        }
        this.m_var.dualLink = false;
        this.m_var.highFreq1 = false;
        this.m_var.lineTotal = this.m_htot;
        this.m_var.lineActive = this.m_hres;
        this.m_var.hSyncWidth = this.m_hspw;
        this.m_var.hSyncDelay = this.m_hspd;
        this.m_var.frameActive = this.m_vres;
        this.m_var.vSyncWidth = this.m_vspw;
        this.m_var.vSyncDelay = this.m_vspd;
        this.m_var.NumBitsPerColor = this.m_nbpc;
        this.m_var.lineSerrationAdjustment = this.m_hvsa;
        this.m_var.lineGroupMod = 1;
        this.m_var.videoResolution = 1;
        this.m_interlace = this.m_scan == 2;
        this.m_var.pixelDepth = 8;
        this.m_var.bitRateMax = this.m_xvsi == Xvsi.DVI_D || this.m_xvsi == Xvsi.DVI_A || this.m_xvsi == Xvsi.DPORT ? 1.5E10 : 9.0E9;
    }

    private void checkSync() {
        if (this.m_avst != 0 && this.m_dvst != 0) {
            this.error(2745, "Invalid Color Encoding: AVST and DVST can not both be non-zero");
        }
        switch (this.m_dvst) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                if (this.m_dvst >= 9 && this.m_dvst <= 18) break;
                this.error(2742, "Invalid Color Encoding: DVST = " + this.m_dvst + " is currently not supported");
            }
        }
        switch (this.m_asct) {
            case 1: 
            case 7: 
            case 13: {
                this.error(2075, "The selected ACS Type (ASCT) is currently not supported");
                break;
            }
        }
        if (this.m_dsct == 1 || this.m_dsct == 7 || this.m_dsct >= 9 && this.m_dvst <= 15) {
            this.error(2076, "The selected DCS Type (DSCT) is currently not supported");
        }
        boolean bl = false;
        boolean bl2 = this.m_fmt.getBool("ASRG");
        boolean bl3 = this.m_fmt.getBool("ASGG");
        boolean bl4 = this.m_fmt.getBool("ASBG");
        if ((bl2 || bl3 || bl4 || this.m_avst == 3 || this.m_avst == 4) && this.m_avst != 0) {
            bl = true;
        }
        this.m_var.aComposite = false;
        if (this.m_avst != 0 && this.m_asct != 0 && bl) {
            switch (this.m_ssst) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.m_var.aComposite = true;
                }
            }
        }
        block9 : switch (this.m_avst) {
            case 3: 
            case 4: {
                switch (this.m_asct) {
                    case 4: 
                    case 8: {
                        break;
                    }
                    default: {
                        this.error(2393, "The selected ACS Type (ASCT) and Color Encoding (AVST) are not compatable");
                    }
                }
                switch (this.m_ssst) {
                    case 3: 
                    case 4: 
                    case 5: {
                        break block9;
                    }
                }
                this.error(2395, "The selected Sync Type (SSST) and Color Encoding (AVST) are not compatable");
            }
        }
        switch (this.m_ssst) {
            case 6: 
            case 7: {
                if (this.m_dsct == this.m_asct) break;
                this.error(2391, "The selected ACS Type (ASCT) and DCS Type (DSCT) are not compatable");
            }
        }
        block21 : switch (this.m_ssst) {
            case 5: 
            case 7: {
                block25 : switch (this.m_dsst) {
                    case 1: {
                        switch (this.m_asct) {
                            case 0: 
                            case 2: 
                            case 3: 
                            case 4: {
                                break block25;
                            }
                        }
                        this.error(2392, "The selected ACS Type (ASCT) and DSS Type (DSST) are not compatable");
                        break;
                    }
                    case 2: {
                        switch (this.m_asct) {
                            case 0: 
                            case 9: 
                            case 10: {
                                break block25;
                            }
                        }
                        this.error(2392, "The selected ACS Type (ASCT) and DSS Type (DSST) are not compatable");
                        break;
                    }
                    case 3: {
                        switch (this.m_asct) {
                            case 0: 
                            case 11: 
                            case 12: {
                                break block25;
                            }
                        }
                        this.error(2392, "The selected ACS Type (ASCT) and DSS Type (DSST) are not compatable");
                        break;
                    }
                    case 4: {
                        switch (this.m_asct) {
                            case 0: 
                            case 14: 
                            case 15: {
                                break block25;
                            }
                        }
                        this.error(2392, "The selected ACS Type (ASCT) and DSS Type (DSST) are not compatable");
                        break;
                    }
                    case 5: {
                        switch (this.m_asct) {
                            case 0: 
                            case 6: 
                            case 8: {
                                break block25;
                            }
                        }
                        this.error(2392, "The selected ACS Type (ASCT) and DSS Type (DSST) are not compatable");
                    }
                }
                if (this.m_ssst == 5) break;
            }
            case 11: {
                switch (this.m_dsst) {
                    case 1: {
                        switch (this.m_dsct) {
                            case 0: 
                            case 2: 
                            case 3: 
                            case 4: {
                                break block21;
                            }
                        }
                        this.error(2400, "The selected DCS Type (DSCT) and DSS Type (DSST) are not compatable");
                        break block21;
                    }
                    case 2: {
                        switch (this.m_dsct) {
                            case 0: 
                            case 9: 
                            case 10: {
                                break block21;
                            }
                        }
                        this.error(2400, "The selected DCS Type (DSCT) and DSS Type (DSST) are not compatable");
                        break block21;
                    }
                    case 3: {
                        switch (this.m_dsct) {
                            case 0: 
                            case 11: 
                            case 12: {
                                break block21;
                            }
                        }
                        this.error(2400, "The selected DCS Type (DSCT) and DSS Type (DSST) are not compatable");
                        break block21;
                    }
                    case 4: {
                        switch (this.m_dsct) {
                            case 0: 
                            case 14: 
                            case 15: {
                                break block21;
                            }
                        }
                        this.error(2400, "The selected DCS Type (DSCT) and DSS Type (DSST) are not compatable");
                        break block21;
                    }
                    case 5: {
                        switch (this.m_dsct) {
                            case 0: 
                            case 6: 
                            case 7: 
                            case 8: {
                                break block21;
                            }
                        }
                        this.error(2400, "The selected DCS Type (DSCT) and DSS Type (DSST) are not compatable");
                    }
                }
            }
        }
    }

    private void checkAfd() {
        double d;
        int n = this.m_fmt.getInt("XLBW");
        int n2 = this.m_fmt.getInt("XRBW");
        int n3 = this.m_fmt.getInt("XTBH");
        int n4 = this.m_fmt.getInt("XBBH");
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            this.error(2065, "AFD: One or more specified border values are negative");
        }
        if (n + n2 >= this.m_fmt.getInt("HRES")) {
            this.error(2065, "AFD: Bar Left (XLBW) + Bar Right (XRBW) must be less than Horizontal Active (HRES)");
        }
        if (n3 + n4 >= this.m_fmt.getInt("VRES")) {
            this.error(2065, "AFD: Bar Top (XTBH) + Bar Bottom (XBBH) must be less than Vertical Active (VRES)");
        }
        if ((d = this.m_fmt.getDouble("CXAR")) < 0.3 || d > 3.0) {
            this.error(2126, "AFD: Invalid Content Aspect Ratio (CXAR): must be in the range 0.3 to 3.0");
        }
        if ((d = this.m_fmt.getDouble("SXAR")) < 0.3 || d > 3.0) {
            this.error(2129, "AFD: Invalid Signal Aspect Ratio (SXAR): must be in the range 0.3 to 3.0");
        }
        if ((d = this.m_fmt.getDouble("EXAR")) < 0.3 || d > 3.0) {
            this.error(2063, "AFD: Invalid Embedded Aspect Ratio (EXAR): must be in the range 0.3 to 3.0");
        }
    }

    private void checkHdtv() {
        this.m_var.hdtvType = 0;
        this.m_var.hdtv = false;
        switch (this.m_asct) {
            case 9: 
            case 10: {
                this.m_var.hdtvType = 1;
                break;
            }
            case 11: 
            case 12: {
                this.m_var.hdtvType = 2;
                break;
            }
            case 14: 
            case 15: {
                this.m_var.hdtvType = 3;
            }
        }
        switch (this.m_dsst) {
            case 2: {
                this.m_var.hdtvType = 1;
                break;
            }
            case 3: {
                this.m_var.hdtvType = 2;
                break;
            }
            case 4: {
                this.m_var.hdtvType = 3;
            }
        }
        switch (this.m_dsst) {
            case 2: 
            case 3: 
            case 4: {
                this.m_var.hdtv = true;
                break;
            }
            default: {
                this.m_var.hdtv = false;
            }
        }
        switch (this.m_asct) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                this.m_var.hdtv = true;
                break;
            }
            default: {
                this.m_var.hdtv = false;
            }
        }
        if (this.m_var.hdtv) {
            switch (this.m_dsct) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: {
                    this.error(2078, "The selected DCS Type (DSCT) is not allowed on HDTV");
                }
            }
        }
    }

    private void checkXvsi() {
        block0 : switch (this.m_xvsi) {
            case SVIDEO: 
            case CVBS: {
                this.m_usingTV = true;
                switch (this.m_avst) {
                    case 3: 
                    case 4: {
                        this.m_var.NumBitsPerColor = 8;
                        this.m_var.frameActive += 4;
                        this.m_vres += 4;
                        ++this.m_var.vSyncDelay;
                        break block0;
                    }
                }
                this.error(2747, "Invalid Color Encoding (AVST) for the selected interface");
                break;
            }
            case SDI: {
                this.m_usingTV = true;
                this.m_usingSDI = true;
                switch (this.m_dvst) {
                    case 14: 
                    case 15: {
                        this.m_var.NumBitsPerColor = 10;
                        break block0;
                    }
                }
                this.error(2742, "Invalid Color Encoding (DVST) for the selected interface");
                break;
            }
            case ANALOG: 
            case DVI_A: {
                if (this.m_avst != 0) break;
                this.error(2747, "Invalid Color Encoding (AVST) for the selected interface");
                break;
            }
            case DVI_D: {
                this.m_usingDVI = true;
                switch (this.m_dvst) {
                    case 0: {
                        this.error(2741, "Invalid Color Encoding (DVST) for the selected interface");
                        break block0;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                this.error(2741, "Invalid Color Encoding (DVST) for the selected interface");
                break;
            }
            case HDMI_H: 
            case HDMI_D: {
                this.m_usingHDMI = true;
                switch (this.m_dvst) {
                    case 0: {
                        this.error(2741, "Invalid Color Encoding (DVST) for the selected interface");
                        break block0;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: {
                        break block0;
                    }
                }
                this.error(2741, "Invalid Color Encoding (DVST) for the selected interface");
                break;
            }
            case DPORT: {
                this.m_usingDP = true;
                switch (this.m_dvst) {
                    case 0: {
                        this.error(2741, "Invalid Color Encoding (DVST) for the selected interface");
                        break block0;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: {
                        break block0;
                    }
                }
                this.error(2741, "Invalid Color Encoding (DVST) for the selected interface");
            }
        }
        if (this.hasUnifiedMemory() && this.m_xvsi != Xvsi.DPORT && this.m_hres > 2048) {
            this.error(2152, "The selected Unit type does not support a Horizontal Active (HRES) greater than 2048 pixels");
        }
    }

    private void checkdigitalOpts() {
        switch (this.m_nbpc) {
            case 0: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                if (!this.m_usingHDMI) break;
                switch (this.m_nbpc) {
                    case 6: {
                        this.error(2082, "The Bits per Color Component value is not allowed for the selected interface");
                        break;
                    }
                    case 0: 
                    case 8: {
                        break;
                    }
                    case 10: 
                    case 12: {
                        if (this.m_dvsm == 2 || this.m_unit != UnitType.C_CA && this.m_unit != UnitType.D && this.m_unit != UnitType.E) break;
                        this.error(2082, "Digital Video Sampling Mode: 10/12 bit color only works with deep color units");
                    }
                }
                break;
            }
            default: {
                this.error(2082, "Invalid NBPC (" + this.m_nbpc + ")");
            }
        }
        block8 : switch (this.m_dvsm) {
            case 0: {
                break;
            }
            case 2: {
                if (this.m_usingHDMI || this.m_usingSDI || this.m_usingDP) {
                    switch (this.m_dvst) {
                        case 13: 
                        case 14: 
                        case 15: 
                        case 17: 
                        case 18: {
                            break block8;
                        }
                    }
                    this.error(2085, "The selected Digital Video Sampling Mode (DVSM) is not supported for the selected interface and Color Encoding (DVST)");
                    break;
                }
                this.error(2085, "The selected Digital Video Sampling Mode (DVSM) is not supported for the selected interface");
                break;
            }
            case 4: {
                if (!this.m_usingSDI) break;
                this.error(2085, "The selected Digital Video Sampling Mode (DVSM) is not supported for the selected interface");
                break;
            }
            default: {
                this.error(2085, "DVSM (" + this.m_dvsm + ") not supported");
            }
        }
        if (this.m_fmt.getInt("NPPP") > 0 && this.m_ncpp > 1) {
            this.error(2062, "Pixel repetition and double clocking not allowed");
        }
    }

    private void checkPixelRate() {
        if (this.m_usingDVI) {
            switch (this.m_nlnk) {
                case 1: {
                    this.m_var.pixelRateLid = 1.66E8;
                    break;
                }
                case 2: {
                    this.m_var.pixelRateLid = 3.31E8;
                    this.m_var.dualLink = true;
                    break;
                }
                default: {
                    this.error(2079, "The selected Number of Links (NLNK) is invalid for the selected interface");
                    break;
                }
            }
        } else if (this.m_usingHDMI) {
            switch (this.m_nlnk) {
                case 0: 
                case 1: {
                    this.m_var.pixelRateLid = 1.66E8;
                    break;
                }
                default: {
                    this.error(2079, "The selected Number of Links (NLNK) is invalid for the selected interface");
                    break;
                }
            }
        } else if (this.m_usingDP) {
            switch (this.m_nlnk) {
                case 0: 
                case 1: {
                    this.m_var.pixelRateLid = 3.61E8;
                    break;
                }
                default: {
                    this.error(2079, "The selected Number of Links (NLNK) is invalid for the selected interface");
                    break;
                }
            }
        } else {
            switch (this.m_avst) {
                case 3: 
                case 4: {
                    this.m_var.pixelRateLid = 1.9E7;
                    break;
                }
                default: {
                    this.m_var.pixelRateLid = this.m_unit == UnitType.D ? 4.01E8 : 2.51E8;
                }
            }
        }
        this.m_var.pixelRateActual = this.m_prat;
        if (!this.m_usingDP && this.m_var.pixelRateActual > this.m_var.pixelRateLid) {
            this.error(2071, "Pixel (or horizontal) Rate is too high.");
        }
    }

    private void checkVideoMode() {
        VideoMode videoMode = null;
        videoMode = this.m_usingHDMI || this.m_usingDVI ? (this.m_var.dualLink ? VideoMode.getEntry(this.m_unit, VideoInterface.DVI_DL, this.m_var.pixelRateActual, this.m_var.pixelDepth, this.m_ncpp) : VideoMode.getEntry(this.m_unit, VideoInterface.DVI_SL, this.m_var.pixelRateActual, this.m_var.pixelDepth, this.m_ncpp)) : (this.m_usingDP ? VideoMode.getEntry(this.m_unit, VideoInterface.DPORT, this.m_var.pixelRateActual, this.m_var.pixelDepth, this.m_ncpp) : (this.m_usingTV || this.m_usingSDI ? VideoMode.getEntry(this.m_unit, VideoInterface.TV, this.m_var.pixelRateActual, this.m_var.pixelDepth, this.m_ncpp) : VideoMode.getEntry(this.m_unit, VideoInterface.ANALOG, this.m_var.pixelRateActual, this.m_var.pixelDepth, this.m_ncpp)));
        if (videoMode == null) {
            this.error(2059, "Invalid Mode: The Pixel Rate (PRAT), Pixel Depth (PELD), and Clocks per Pixel (NCPP) combination is not supported by the selected unit / interface");
            return;
        }
        this.m_var.highFreq1 = videoMode.m_isHighFreq1;
        this.m_var.lineGroupMod = videoMode.m_lineGroupMod;
        this.m_var.videoResolution = videoMode.m_videoResolution;
        this.m_var.syncResolution = videoMode.m_syncResolution;
        this.m_var.lineTotal = this.m_var.syncResolution * this.m_htot / this.m_var.videoResolution;
        this.m_var.lineActive = this.m_var.syncResolution * this.m_hres / this.m_var.videoResolution;
        this.m_var.hSyncWidth = this.m_var.syncResolution * this.m_hspw / this.m_var.videoResolution;
        this.m_var.hSyncDelay = this.m_var.syncResolution * this.m_var.hSyncDelay / this.m_var.videoResolution;
        this.m_prat = (double)this.m_var.syncResolution * this.m_var.pixelRateActual / (double)this.m_var.videoResolution;
        if (!this.m_var.highFreq1) {
            this.m_prat *= 2.0;
        }
        if (this.m_avst != 0) {
            block0 : switch (this.m_ssst) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    switch (this.m_asct) {
                        case 9: 
                        case 11: 
                        case 14: {
                            this.m_var.hSyncDelay -= this.m_var.hSyncWidth;
                            this.m_var.hSyncWidth += this.m_var.hSyncWidth;
                            break block0;
                        }
                    }
                    break;
                }
            }
            block6 : switch (this.m_ssst) {
                case 3: 
                case 4: {
                    switch (this.m_asct) {
                        case 5: {
                            if (this.m_hspp == this.m_vspp) break block6;
                            this.m_var.vSyncWidth = 0;
                            break block6;
                        }
                    }
                    break;
                }
                case 2: 
                case 6: {
                    switch (this.m_dsct) {
                        case 5: {
                            if (this.m_hspp == this.m_vspp) break block6;
                            this.m_var.vSyncWidth = 0;
                            break block6;
                        }
                    }
                    break;
                }
            }
        }
        if (this.m_avst != 0) {
            if (this.m_prat < 39350.393700787405) {
                this.error(2080, "The Horizontal Rate (HRAT) or Pixel Rate is too low");
            }
        } else if (this.m_usingDVI || this.m_usingHDMI) {
            if (!this.m_var.dualLink) {
                if (this.m_var.pixelRateActual * (double)this.m_ncpp < 2.454E7) {
                    this.error(2080, "The Horizontal Rate (HRAT) or Pixel Rate is too low");
                }
            } else if (this.m_var.pixelRateActual * (double)this.m_ncpp < 4.908E7) {
                this.error(2080, "The Horizontal Rate (HRAT) or Pixel Rate is too low");
            }
        }
    }

    private void checkHorz() {
        if (this.m_hrat * 65535.0 * (double)this.m_var.videoResolution < 4997500.0) {
            this.error(2080, "The Horizontal Rate (HRAT) is too low");
        }
        this.m_var.lineRate = this.m_prat / (double)this.m_var.lineTotal;
        if (this.m_var.lineTotal < this.m_var.lineActive) {
            this.error(2151, "HTOT is less than HRES");
        }
        if (this.m_avst != 0 && (this.m_htot & 1) != 0) {
            if (this.m_scan == 1) {
                this.error(2090, "The Horizontal Total (HTOT) must be even in interlaced mode with an analog Color Encoding (AVST)");
            }
            switch (this.m_ssst) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    switch (this.m_asct) {
                        case 4: 
                        case 8: 
                        case 11: 
                        case 12: 
                        case 14: 
                        case 15: {
                            this.error(2090, "The Horizontal Total (HTOT) must be even with an analog Color Encoding (AVST) and the selected  Sync Type (SSST) and ACS Type (ASCT)");
                        }
                    }
                }
            }
            switch (this.m_ssst) {
                case 2: 
                case 6: 
                case 7: 
                case 11: {
                    switch (this.m_dsct) {
                        case 4: 
                        case 5: 
                        case 8: 
                        case 11: 
                        case 12: 
                        case 14: 
                        case 15: {
                            this.error(2090, "The Horizontal Total (HTOT) must be even with an analog Color Encoding (AVST) and the selected  Sync Type (SSST)");
                        }
                    }
                }
            }
        }
        if (this.m_usingHDMI || this.m_usingDVI || this.m_usingDP) {
            if (this.m_var.dualLink) {
                if ((this.m_htot & 1) != 0) {
                    this.error(2090, "The Horizontal Total (HTOT) must be even in dual-link mode");
                }
                if ((this.m_hres & 1) != 0) {
                    this.error(2092, "The Horizontal Active (HRES) must be even in dual-link mode");
                }
                if ((this.m_hspw & 1) != 0) {
                    this.error(2093, "The Horizontal Sync Pulse Width (HSPW) must be even in dual-link mode");
                }
                if ((this.m_hspd & 1) != 0) {
                    this.error(2094, "The Horizontal Sync Pulse Delay (HSPD) must be even in dual-link mode");
                }
            }
        } else if ((this.m_usingTV || this.m_usingSDI) && this.m_scan == 2) {
            if ((this.m_htot & 1) != 0) {
                this.error(2090, "The Horizontal Total (HTOT) must be even in interlace mode on the selected interface");
            }
            if ((this.m_hres & 1) != 0) {
                this.error(2092, "The Horizontal Active (HRES) must be even in interlace mode on the selected interface");
            }
        }
        if (this.m_var.videoResolution == 2 && (this.m_htot & 1) != 0) {
            this.error(2090, "The The Horizontal Total (HTOT) must be even");
        }
        this.m_var.lineTotalTicks = this.m_var.lineTotal;
        if (this.m_var.lineTotalTicks > 65535) {
            this.error(2090, "The The Horizontal Total (HTOT) is too large");
        }
        this.m_var.lineBlank = this.m_var.lineTotal - this.m_var.lineActive;
        int n = this.m_hres / this.m_var.lineGroupMod;
        if (this.m_hres % this.m_var.lineGroupMod != 0) {
            ++n;
        }
        this.m_var.lineScreenPixels = n * this.m_var.lineGroupMod;
        if (this.m_var.lineScreenPixels < this.m_var.lineGroupMod) {
            this.error(2130, "The The Horizontal Active (HRES) is too small");
        }
        if (this.m_var.aComposite) {
            if (this.m_var.hSyncWidth > this.m_var.lineBlank) {
                this.error(2200, "The Horizontal pulse width (HSPW) is too large");
            }
        } else if (this.m_var.hSyncWidth > this.m_var.lineTotal - 1) {
            this.error(2200, "The Horizontal pulse width (HSPW) is too large");
        }
        if (this.m_var.aComposite && this.m_var.hdtv) {
            if (this.m_hspw < 2) {
                this.error(2190, "The Horizontal pulse width (HSPW) is too small for HDTV");
            }
            if ((this.m_hspw & 1) == 1) {
                this.error(2191, "The Horizontal pulse width (HSPW) must be even for HDTV");
            }
        }
        if (this.m_var.videoResolution == 2 && (this.m_hspw & 1) != 0) {
            this.error(2193, "The Horizontal pulse width (HSPW) must be even");
        }
        switch (this.m_var.hdtvType) {
            case 0: {
                if (this.m_hvsa <= this.m_hspw) break;
                this.error(2231, "The Serration width Adjustment (HVSA is too large");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.m_hvsa <= this.m_hspd) break;
                this.error(2231, "The Serration width Adjustment (HVSA is too large");
            }
        }
        if (this.m_var.aComposite) {
            if (this.m_var.hSyncDelay > this.m_var.lineBlank - this.m_var.hSyncWidth) {
                this.error(2230, "The Horizontal sync pulse extends beyond blanking");
            }
        } else if (this.m_var.hSyncDelay > this.m_var.lineTotal - this.m_var.hSyncWidth - 1) {
            this.error(2230, "The Horizontal pulse delay is beyond end of line");
        }
        if (this.m_var.videoResolution == 2 && (this.m_hspd & 1) != 0) {
            this.error(2094, "The Horizontal pulse delay must be even");
        }
    }

    private void checkVert() {
        if (this.m_interlace) {
            if (this.m_vtot < 5) {
                this.error(2250, "The Vertical total (VTOT) is too small for interlaced mode");
            }
            if ((this.m_vtot & 1) == 0 && !this.m_var.hdtv && this.m_asct != 5 && this.m_dsct != 5 && this.m_dsst != 6 && this.m_dsst != 7) {
                this.error(2270, "The Vertical total (VTOT) can not be even with the current settings");
            }
            if (this.m_vtot > 8191) {
                this.error(2280, "The Vertical total (VTOT) is too large");
            }
        } else {
            if (this.m_vtot < 2) {
                this.error(2250, "The Vertical total (VTOT) is too small");
            }
            if (this.m_vtot > 4095) {
                this.error(2280, "The Vertical total (VTOT) is too large");
            }
        }
        this.m_var.gspVTOTAL = this.m_vtot - 1;
        this.m_var.frameScreen = this.m_vres;
        this.m_var.frameMasked = this.m_vtot - this.m_var.frameScreen;
        if (this.m_interlace) {
            if (this.m_var.frameScreen < 2) {
                this.error(2320, "The Vertical active (VRES) is too small for interlace mode");
            }
            if ((this.m_var.frameScreen & 1) == 1) {
                switch (this.m_asct) {
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 14: 
                    case 15: {
                        break;
                    }
                    default: {
                        this.error(2321, "The Vertical active (VRES) must be even with the current settings");
                    }
                }
            }
            if (this.m_vtot - this.m_var.frameScreen < 3) {
                this.error(2330, "The Vertical Blanking is too small for interlace mode");
            }
        } else {
            if (this.m_var.frameScreen < 1) {
                this.error(2300, "The Vertical Active (VRES) is too small");
            }
            if (this.m_var.frameScreen > this.m_vtot - 1) {
                this.error(2310, "The Vertical Blanking is too small");
            }
        }
        if (this.m_var.aComposite) {
            if (this.m_interlace) {
                if (this.m_vspw > this.m_var.gspVTOTAL - this.m_var.frameScreen / 2 - 1) {
                    this.error(2390, "The Verical Pulse Width (VSPW) is too large for interlace mode");
                }
            } else if (this.m_vspw > this.m_vtot - this.m_var.frameScreen) {
                this.error(2370, "The Verical Pulse Width (VSPW) is too large");
            }
        } else if (this.m_interlace) {
            if (this.m_vspw > this.m_var.gspVTOTAL - 1) {
                this.error(2390, "The Verical Pulse Width (VSPW) is too large for interlace mode");
            }
        } else if (this.m_vspw > this.m_vtot - 1) {
            this.error(2370, "The Verical Pulse Width (VSPW) is too large");
        }
        if (this.m_var.aComposite) {
            if (this.m_interlace) {
                if (this.m_var.vSyncDelay > this.m_var.gspVTOTAL - this.m_var.frameScreen / 2 - this.m_vspw) {
                    this.error(2450, "The Vertical Pulse extends beyond blanking (interlace)");
                }
            } else if (this.m_var.vSyncDelay > this.m_vtot - this.m_var.frameScreen - this.m_vspw) {
                this.error(2430, "The Vertical Pulse extends beyond blanking");
            }
        } else if (this.m_interlace) {
            if (this.m_var.vSyncDelay > this.m_var.gspVTOTAL - this.m_vspw) {
                this.error(2450, "The Vertical Pulse extends beyond blanking (interlace)");
            }
        } else if (this.m_var.vSyncDelay > this.m_vtot - this.m_vspw) {
            this.error(2430, "The Vertical Pulse extends beyond blanking");
        }
        if (this.m_equb > this.m_var.vSyncDelay) {
            this.error(2490, "The Equalizations Before (EQUB) is too large");
        }
        if (this.m_interlace) {
            if (this.m_equa > this.m_var.gspVTOTAL - this.m_var.frameScreen / 2 - this.m_var.vSyncDelay - this.m_vspw) {
                this.error(2495, "The Equalizations After (EQUA) is too large for interlace mode");
            }
        } else if (this.m_equa > this.m_vtot - this.m_var.frameScreen - this.m_var.vSyncDelay - this.m_vspw) {
            this.error(2496, "The Equalizations After (EQUA) is too large");
        }
        if (this.hasVarDepthGC()) {
            if ((double)this.m_var.pixelDepth * this.m_var.pixelRateActual > this.m_var.bitRateMax) {
                this.error(2072, "The Horizontal Rate (HRAT) is too high");
            }
        } else if (32.0 * this.m_var.pixelRateActual > this.m_var.bitRateMax) {
            this.error(2072, "The Horizontal Rate (HRAT) is too high");
        }
    }

    private void checkAudio() {
        double d = this.m_fmt.getDouble("ARAT");
        long l = Math.round(d / 100.0);
        switch ((int)l) {
            case 320: 
            case 441: 
            case 480: 
            case 960: 
            case 1764: 
            case 1920: {
                break;
            }
            default: {
                this.error(2088, "Invalid Sampling Rate (ARAT)");
            }
        }
        int n = this.m_fmt.getInt("DAST");
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                this.error(2111, "The selected Audio Signal Type (DAST) is currently not supported");
            }
        }
        int n2 = this.m_fmt.getInt("DASI");
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                this.error(2112, "The selected Audio Signal Interface (DASI) is currently not supported");
            }
        }
    }

    private void checkMemory() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.hasUnifiedMemory()) {
            n4 = this.m_hres;
        } else {
            for (n4 = 16; this.m_var.lineScreenPixels > n4; n4 <<= 1) {
            }
        }
        if (this.hasVarDepthGC()) {
            if (this.m_var.pixelDepth == 32 && n4 > 4096) {
                this.error(2551, "Insufficient memory for the specified resolution");
            }
        } else if ((this.m_unit == UnitType.D || this.m_unit == UnitType.E) && n4 < 1024) {
            n4 = 1024;
        }
        int n5 = this.hasVarDepthGC() ? n4 * this.m_var.pixelDepth : n4 * 32;
        if (this.m_usingTV || this.m_usingSDI) {
            n5 *= 2;
        }
        if (!this.hasVarDepthGC() && n5 / 32 > 4096) {
            this.error(2551, "The Picture width is too large for the selected unit.");
        }
        int n6 = 0x10000000;
        if (!this.hasVarDepthGC()) {
            n6 *= 2;
        }
        if ((n3 = n6 / n5) > Short.MAX_VALUE) {
            n3 = Short.MAX_VALUE;
        }
        if ((n2 = n6 / (n = n3 * n5)) < 1 || n3 < this.m_var.frameScreen) {
            this.error(2550, "The selected unit has insufficient image memory to support the specified format");
        }
    }

    private void checkMisc() {
        double d;
        boolean bl = true;
        if (this.m_avst != 0 || this.m_usingHDMI || this.m_usingDVI || this.m_usingDP) {
            bl = false;
        }
        if (this.m_fmt.getBool("AVPG") && ((d = this.m_fmt.getDouble("AVPS")) < 0.0 || d > 100.0)) {
            this.msg(bl, 2714, "The Pedestal swing (AVPS) is out of range [0 to 100]");
        }
        if (this.m_fmt.getBool("GAMC") && ((d = this.m_fmt.getDouble("GAMA")) < 0.1 || d > 10.0)) {
            this.msg(bl, 2715, "The Gama Correction (GAMA) is out of range [0.1 to 10]");
        }
        switch (this.m_avst) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                d = this.m_fmt.getDouble("AVSS");
                if (d < 0.0 || d > 1.1) {
                    this.msg(bl, 2716, "The Analog Video Swing (AVSS) is out of range [0 to 1.1]");
                }
                if (!((d = this.m_fmt.getDouble("ASSS")) < 0.0) && !(d > 0.5)) break;
                this.msg(bl, 2717, "The Analog Sync Swing (ASSS) is out of range [0 to 0.5]");
                break;
            }
        }
        d = this.m_fmt.getDouble("DVSS");
        if (d < 0.0 || d > 1.95) {
            this.error(2761, "The Digital Video Swing #1 is out of range [0 to 1.95]");
        }
        if ((d = this.m_fmt.getDouble("DVSS2")) < 0.0 || d > 1.95) {
            this.error(2761, "The Digital Video Swing #2 is out of range [0 to 1.95]");
        }
    }

    private boolean hasUnifiedMemory() {
        switch (this.m_unit) {
            case C_CA: 
            case D: 
            case E: {
                return false;
            }
        }
        return true;
    }

    private boolean hasVarDepthGC() {
        return this.m_unit == UnitType.C_CA;
    }

    private class Vars {
        public boolean dualLink;
        public boolean highFreq1;
        public boolean aComposite;
        public int hdtvType = 0;
        public boolean hdtv = false;
        public int lineTotal;
        public int lineActive;
        public int hSyncWidth;
        public int hSyncDelay;
        public int frameActive;
        public int vSyncWidth;
        public int vSyncDelay;
        public int NumBitsPerColor;
        public int lineSerrationAdjustment;
        public int lineTotalTicks;
        public int lineBlank;
        public int lineScreenPixels;
        public int gspVTOTAL;
        public int frameScreen;
        public int frameMasked;
        public int pixelDepth;
        public double bitRateMax;
        public double pixelRateLid;
        public double pixelRateActual;
        public double lineRate;
        public int lineGroupMod;
        public int videoResolution;
        public int syncResolution;

        private Vars() {
        }
    }
}

